ORCA/M Asm65816 2.1.0

0001 7708
0002 7708              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0003 7708              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 3:48:55 PM
0004 7708
0005 7708
0006 7708                       TITLE 'Cortland Mouse MISC'
0007 7708
0008 7708              ********************************************************
0009 7708              *                                                      *
0010 7708              *                    Cortland Mouse                    *
0011 7708              *                                                      *
0012 7708              *                    MISC Routines                     *
0013 7708              *                                                      *
0014 7708              *                          by                          *
0015 7708              *                     Fern Bachman                     *
0016 7708              *                     Joe  Bo                          *
0017 7708              *                                                      *
0018 7708              *     Copyright  1984-1989 by Apple Computer, Inc.     *
0019 7708              *                 All Rights Reserved                  *
0020 7708              *                                                      *
0021 7708              ********************************************************
0022 7708
0023 7708
0024 7708                                                      ; SEG $FF
0025 7708              MOUSE_DISPATCHER EQU   *
0026 7708                                                      ; SEG $00
0027 7708
0028 7708 D8                    CLD                            ;No decimal mode in here
0029 7709 7C 0C 77              JMP   (MOUSE_RTNES,X)          ;Off to routine immediately
0030 770C
0031 770C
0032 770C              MOUSE_RTNES EQU   *
0033 770C 07 78                 DC W:INITMOUSE                 	;(0) Initialize mouse routine
0034 770E 17 78                 DC W:CLAMPMOUSE                ;(2) Set mouse clamps
0035 7710 B2 77                 DC W:READMOUSE                 	;(4) Read mouse info and update for user
0036 7712 23 77                 DC W:MOUSEBASIC                ;(6) Do mouse stuff for BASIC
0037 7714 8D 77                 DC W:HOMEMOUSE                 	;(8) Do home mouse stuff
0038 7716 18 77                 DC W:SETMOUSE                  	;(A) Do set mouse stuff
0039 7718
0040 7718
0041 7718              SETMOUSE EQU   *
0042 7718 C2 30                 REP   #$30                     ;16-bit m/x for tool
0043 771A                       LONGA ON
0044 771A                       LONGI ON
0045 771A 48                    PHA                            ;Low byte contain mouse mode from user
0046 771B A2 03 19              LDX   #$1903                   ;Set Mouse mode call
0047 771E 22 00 00 E1           JSL   >DISPATCH1               ;DO IT
0048 7722 6B                    RTL                            ;Return to $c4xx
0049 7723
0050 7723
0051 7723              MOUSEBASIC EQU   *
0052 7723                       LONGA OFF                      	;8-bit m/x entry
0053 7723                       LONGI OFF
0054 7723 BB                    TYX                            ;Restore 'X' value
0055 7724 B0 1F                 BCS   @11                      ;C=1 if BASIC input
0056 7726 A0 C4                 LDY   #>OENTBAS                ;Y must be current $Cn
0057 7728 C4 39                 CPY   KSWH                     ;Are input hooks requested?
0058 772A D0 04                 BNE   @1                       ;<>= BASIC wants to do output
0059 772C A4 38                 LDY   KSWL                     ;Test lo byte of input hook
0060 772E F0 15                 BEQ   @11                      ;If so must be IN call
0061 7730              @1       EQU   *
0062 7730 48                    PHA                            ;Save A on stack
0063 7731 DA                    PHX                            ;Save X on stack
0064 7732 29 7F                 AND   #$7F                     ;No high bits
0065 7734 C9 02                 CMP   #$02                     ;User must send 0 or 1 only
0066 7736 B0 09                 BCS   @12                      ;Exit with no changes
0067 7738 08                    PHP                            ;No interrupts in here
0068 7739 78                    SEI                            ;
0069 773A 20 60 C4              JSR   TSETMOUSE                ;Set mouse mode
0070 773D 20 76 C4              JSR   TINITMOUSE               ;Initialize mouse defaults
0071 7740 28                    PLP                            ;Restore interrupt status
0072 7741              @12      EQU   *
0073 7741 FA                    PLX                            ;Restore X
0074 7742 68                    PLA                            ;Restore A
0075 7743 80 47                 BRA   MBASICOUT4               ;Back to BASIC
0076 7745
0077 7745              @11      EQU   *
0078 7745 EB                    XBA                            ;Recall user 'Y' value from stack
0079 7746 A3 07                 LDA   7,S                      ;Gets it
0080 7748 A8                    TAY                            ;Move to 'Y'
0081 7749 EB                    XBA                            ;Restore 'A' value now
0082 774A 91 28                 STA   (BASL),Y                 ;Replace flashing char
0083 774C A0 05                 LDY   #<IENTBAS                ;Lo byte of input hook
0084 774E 84 38                 STY   KSWL                     ;Save in input hook
0085 7750 08                    PHP                            ;No interrupts in here
0086 7751 78                    SEI                            ;
0087 7752 22 B2 77 FF           JSL   >READMOUSE               ;Update position and status
0088 7756 AD 7C 04              LDA   LO                       ;Pick up lo X byte
0089 7759 AE 7C 05              LDX   HI                       ;Pick up hi X byte
0090 775C A0 05                 LDY   #$05                     ;Pstn of last byte of ASCII
0091 775E 20 82 78              JSR   MHEXTODEC                ;Make ASCII in buffer
0092 7761 AD FC 04              LDA   LO+$80                   ;Pick up lo Y byte
0093 7764 AE FC 05              LDX   HI+$80                   ;Pick up hi Y byte
0094 7767 A0 0C                 LDY   #$0C                     ;Pstn of last byte of ASCII
0095 7769 20 82 78              JSR   MHEXTODEC                ;Make ASCII in buffer
0096 776C AD 00 C0              LDA   KBD                      ;JSR XRDKBD ;Was a key pressed?
0097 776F 0A                    ASL   A                        ;Move bit 7 to C
0098 7770 08                    PHP                            ;Save status on stack
0099 7771 AD 7C 07              LDA   BUTTON                   ;Pick up button status
0100 7774 2A                    ROL   A                        ;Move bits 6/7 to 0/1
0101 7775 2A                    ROL   A                        ;
0102 7776 2A                    ROL   A                        ;
0103 7777 29 03                 AND   #$03                     ;Strip off excess bits
0104 7779 49 03                 EOR   #$03                     ;Flip bits
0105 777B 1A                    INC   A                        ;Add 1
0106 777C 28                    PLP                            ;Recall status
0107 777D A2 00                 LDX   #$00                     ;Hi byte is always $00
0108 777F A0 10                 LDY   #$10                     ;Pstn of last byte of ASCII
0109 7781 20 93 78              JSR   HEXDEC2                  ;Go place in input buffer
0110 7784 A9 8D                 LDA   #$8D                     ;A must be CR to exit
0111 7786 8D 11 02              STA   IN+$11                   ;Save as last character
0112 7789 A2 11                 LDX   #$11                     ;Set X to $11
0113 778B 28                    PLP                            ;Restore interrupt status
0114 778C              MBASICOUT4 EQU   *
0115 778C 6B                    RTL                            ;Back to caller
0116 778D
0117 778D
0118 778D              HOMEMOUSE EQU   *                       ;User entry point - HOMEMOUSE
0119 778D A2 04                 LDX   #4                       ;4 bytes to move
0120 778F              @11      EQU   *
0121 778F BF B7 02 E1           LDA   >LOWXCLAMP-1,X           ;Get a clamp byte
0122 7793 48                    PHA                            ;Save on stack
0123 7794 CA                    DEX                            ;Loop til done
0124 7795 D0 F8                 BNE   @11                      ;
0125 7797
0126 7797              @12      EQU   *
0127 7797 68                    PLA                            ;Move clamp data to user absolute position
0128 7798 9D 7C 04              STA   LO,X                     ;X=0 for 'X' values - X=$80 for 'Y' values
0129 779B 68                    PLA                            ;
0130 779C 9D 7C 05              STA   HI,X                     ;
0131 779F 8A                    TXA                            ;Test for done
0132 77A0 30 04                 BMI   @13                      ;- then done
0133 77A2 A2 80                 LDX   #$80                     ;+ then do Y value too
0134 77A4 80 F1                 BRA   @12                      ;
0135 77A6
0136 77A6              @13      EQU   *                        ;Need to update bank $e1 mouse params
0137 77A6 C2 30                 REP   #$30                     ;16-bit m/x for tool call
0138 77A8                       LONGA ON
0139 77A8                       LONGI ON
0140 77A8 A2 03 1A              LDX   #$1A03                   ;HomeMouse Call
0141 77AB 22 00 00 E1           JSL   >DISPATCH1               ;DO IT
0142 77AF E2 30                 SEP   #$30
0143 77B1                       LONGA OFF
0144 77B1                       LONGI OFF
0145 77B1 6B                    RTL                            ;Return to my world with 8-bit m/x
0146 77B2
0147 77B2
0148 77B2                                                      ; SEG $FF
0149 77B2              READMOUSE EQU   *
0150 77B2                                                      ; SEG $00
0151 77B2 08                    PHP                            ;No interrupts in here
0152 77B3 78                    SEI                            ;
0153 77B4 AD FC 07              LDA   MOUSMODE                 ;Update bank $e1 mouse stuff w/ screen 
0154 77B7 8F 97 01 E1           STA   >MSEMODE                 ; holes value before the mouse tool call
0155 77BB AD 7C 07              LDA   BUTTON                   ;
0156 77BE 8F 96 01 E1           STA   >MSESTAT                 ;
0157 77C2 AD FC 04              LDA   LO+$80                   ;Low byte of absolute Y
0158 77C5 8F 91 01 E1           STA   >LOWABSY                 ;
0159 77C9 AD FC 05              LDA   HI+$80                   ;High byte of absolute Y
0160 77CC 8F 93 01 E1           STA   >HIGHABSY                ;
0161 77D0 AD 7C 04              LDA   LO                       ;Low byte of absolute X
0162 77D3 8F 90 01 E1           STA   >LOWABSX                 ;
0163 77D7 AD 7C 05              LDA   HI                       ;High byte of absolute X
0164 77DA 8F 92 01 E1           STA   >HIGHABSX                ;
0165 77DE C2 30                 REP   #$30                     ;16-bit m/x for tool call
0166 77E0                       LONGA ON
0167 77E0                       LONGI ON
0168 77E0 48                    PHA                            ;Space for result
0169 77E1 48                    PHA                            ; "
0170 77E2 48                    PHA                            ; "
0171 77E3 A2 03 17              LDX   #$1703                   ;MouseRead call
0172 77E6 22 00 00 E1           JSL   >DISPATCH1               ;DO IT
0173 77EA E2 30                 SEP   #$30                     ;Back to 8-bit mode
0174 77EC                       LONGA OFF
0175 77EC                       LONGI OFF
0176 77EC 68                    PLA                            ;Get mouse mode
0177 77ED 8D FC 07              STA   MOUSMODE                 ;Update screen hole, $7fc
0178 77F0 68                    PLA                            ;Get button status
0179 77F1 8D 7C 07              STA   BUTTON                   ;Update screen hole, $77c
0180 77F4 68                    PLA                            ;Get lo byte of absolute Y pos
0181 77F5 8D FC 04              STA   LO+$80                   ;Update screen hole, $4fc        
0182 77F8 68                    PLA                            ;Get hi byte of absolute Y pos
0183 77F9 8D FC 05              STA   HI+$80                   ;Update screen hole, $5fc
0184 77FC 68                    PLA                            ;Get lo byte of absolute X pos
0185 77FD 8D 7C 04              STA   LO                       ;Update screen hole, $47c
0186 7800 68                    PLA                            ;Get hi byte of absolute X pos
0187 7801 8D 7C 05              STA   HI                       ;Update screen hole, $57c
0188 7804 28                    PLP                            ;Restore interrupt state
0189 7805 18                    CLC                            ;Must exit with carry clear
0190 7806 6B                    RTL                            ;Back to $c4xx
0191 7807
0192 7807
0193 7807              INITMOUSE EQU   *
0194 7807 C2 30                 REP   #$30                     ;16-bit m/x for tool call
0195 7809                       LONGA ON
0196 7809                       LONGI ON
0197 7809 A9 04 00              LDA   #$0004                   ;MouseSlot for tool call
0198 780C 48                    PHA                            ;Push for tool
0199 780D A2 03 18              LDX   #$1803                   ;InitMouse Call
0200 7810 22 00 00 E1           JSL   >DISPATCH1               ;DO IT
0201 7814 E2 30                 SEP   #$30                     ;Back to 8-bit land
0202 7816                       LONGA OFF
0203 7816                       LONGI OFF
0204 7816 6B                    RTL                            ;Back to $c4xx
0205 7817
0206 7817              CLAMPMOUSE EQU   *
0207 7817 48                    PHA                            ;Save user's 'A' first
0208 7818 AD FC 07              LDA   MOUSMODE                 ;Get screen hole mouse mode byte
0209 781B 8F 97 01 E1           STA   >MSEMODE                 ;Update for $e1 mouse mode
0210 781F AD 7C 06              LDA   INFO                     ;Get screen hole mouse info byte
0211 7822 8F 94 01 E1           STA   >MSEINFO                 ;Update for $e1 mouse info location
0212 7826 68                    PLA                            ;Restore user's 'A'
0213 7827 29 01                 AND   #$01                     ;Strip off excess bits
0214 7829 AA                    TAX                            ;X=$00 for X clamps - X=$01 for Y clamps]
0215 782A D0 1E                 BNE   @1                       ;BRA to do Y clamps
0216 782C AD 78 05              LDA   LOWHI                    ;Doing X clamps            
0217 782F 48                    PHA                            ;Push user's values for tool 
0218 7830 AD 78 04              LDA   LOWLO                    ;
0219 7833 48                    PHA                            ;
0220 7834 AD F8 05              LDA   HIGHHI                   ;
0221 7837 48                    PHA                            ;
0222 7838 AD F8 04              LDA   HIGHLO                   ;
0223 783B 48                    PHA                            ;
0224 783C C2 30                 REP   #$30                     ;Off to 16-bit land
0225 783E                       LONGA ON
0226 783E                       LONGI ON
0227 783E AF BA 02 E1           LDA   >LOWYCLAMP               ;When doing X, no change for Y clamps
0228 7842 48                    PHA                            ;
0229 7843 AF BE 02 E1           LDA   >HIYCLAMP                ;
0230 7847 48                    PHA                            ;
0231 7848 80 1E                 BRA   @2                       ;BRA to ClampMouse call
0232 784A
0233 784A              @1       EQU   *
0234 784A C2 30                 REP   #$30                     ;Off to 16-bit land
0235 784C                       LONGA ON
0236 784C                       LONGI ON
0237 784C AF B8 02 E1           LDA   >LOWXCLAMP               ;When doing Y, no change for X
0238 7850 48                    PHA                            ;
0239 7851 AF BC 02 E1           LDA   >HIXCLAMP                ;
0240 7855 48                    PHA                            ;
0241 7856 E2 30                 SEP   #$30                     ;Back to 8-bit land
0242 7858                       LONGA OFF
0243 7858                       LONGI OFF
0244 7858 AD 78 05              LDA   LOWHI                    ;Push in user's values for tool
0245 785B 48                    PHA                            ;
0246 785C AD 78 04              LDA   LOWLO                    ;
0247 785F 48                    PHA                            ;
0248 7860 AD F8 05              LDA   HIGHHI                   ;
0249 7863 48                    PHA                            ;
0250 7864 AD F8 04              LDA   HIGHLO                   ;
0251 7867 48                    PHA                            ;
0252 7868
0253 7868              @2       EQU   *
0254 7868 C2 30                 REP   #$30                     ;16-bit for tool call
0255 786A                       LONGA ON
0256 786A                       LONGI ON
0257 786A A2 03 1C              LDX   #$1C03                   ;ClampMouse Call
0258 786D 22 00 00 E1           JSL   >DISPATCH1               ;DO IT
0259 7871 E2 30                 SEP   #$30                     ;Back to 8-bit land
0260 7873                       LONGA OFF
0261 7873                       LONGI OFF
0262 7873 AF 97 01 E1           LDA   >MSEMODE                 ;Update screen holes mode and info
0263 7877 8D FC 07              STA   MOUSMODE                 ; byte with new values returned
0264 787A AF 94 01 E1           LDA   >MSEINFO                 ; by mouse tool call in bank $e1 
0265 787E 8D 7C 06              STA   INFO                     ; mouse stuff
0266 7881 6B                    RTL                            ;Back to $c4xx
0267 7882
0268 7882
0269 7882              **************************************************
0270 7882              *                                                *
0271 7882              *          MHEXTODEC routine written             *
0272 7882              *                    by                          *
0273 7882              *               Rich Williams                    *
0274 7882              *                                                *
0275 7882              * Data transferred to the input buffer has the   *
0276 7882              * following form.                                *
0277 7882              *                                                *
0278 7882              * s x1 x2 x3 x4 x5, s y1 y2 y3 y4 y5, sb B0 b1 cr*  
0279 7882              *                                                *
0280 7882              *    s = sign and is only placed in buffer if    *
0281 7882              *        number is negative.                     *
0282 7882              *    x1...x5 = up to 5 ascii characters          *
0283 7882              *              giving the decimal value of X.    *
0284 7882              *    y1...y5 = up to 5 ascii characters          *
0285 7882              *              giving the decimal value of Y.    *
0286 7882              *    sb  = - if key pressed // no sign means     *
0287 7882              *           no key was pressed.                  *
0288 7882              *    b5 = 1 if button still pressed              *
0289 7882              *       = 2 if button down but was released      *
0290 7882              *       = 3 if button released but was down      *
0291 7882              *       = 4 if button released and was released  *
0292 7882              *    cr = Carriage return indicated to basic     *
0293 7882              *         the end has been reached.              *
0294 7882              *                                                *
0295 7882              *  Registers must be as follows on entry;        *
0296 7882              *         A = Low byte of number                 *
0297 7882              *         X = High byte of number                *
0298 7882              *         Y = Position of one's digit            *
0299 7882              *                                                *
0300 7882              *       Copyright 1983 Apple Computer, Inc.      *
0301 7882              *                                                *
0302 7882              **************************************************
0303 7882
0304 7882              MHEXTODEC EQU   *
0305 7882 E0 80                 CPX   #$80                     ;Is number -?
0306 7884 90 0D                 BCC   HEXDEC2                  ;
0307 7886 49 FF                 EOR   #$FF                     ;Form 2's complement
0308 7888 69 00                 ADC   #$00                     ;
0309 788A 48                    PHA                            ;Save on stack for later
0310 788B 8A                    TXA                            ;
0311 788C 49 FF                 EOR   #$FF                     ;
0312 788E 69 00                 ADC   #$00                     ;
0313 7890 AA                    TAX                            ;
0314 7891 68                    PLA                            ;Restore A
0315 7892 38                    SEC                            ;
0316 7893              HEXDEC2  EQU   *                        ;
0317 7893 8D 21 02              STA   IN+$21                   ;Store the number to convert 
0318 7896 8E 20 02              STX   IN+$20                   ;
0319 7899 A9 AB                 LDA   #$AB                     ;Plus char in ASCII
0320 789B 90 02                 BCC   @1                       ;
0321 789D A9 AD                 LDA   #$AD                     ;Minus char in ASCII
0322 789F 48           @1       PHA                            ;Save the sign
0323 78A0 A9 AC                 LDA   #$AC                     ;Store a comma after the number
0324 78A2 99 01 02              STA   IN+1,Y                   ;
0325 78A5 20 AD 78              JSR   @2                       ;Convert hex to decimal ASCII
0326 78A8 68                    PLA                            ;Get the sign
0327 78A9 99 00 02              STA   IN,Y                     ;
0328 78AC 60                    RTS                            ;Return to caller
0329 78AD
0330 78AD              @2       EQU   *                        ;Divide by 10
0331 78AD A2 11                 LDX   #16+1                    ;16 bits and 1st time do nothing
0332 78AF A9 00                 LDA   #$00                     ;
0333 78B1 18                    CLC                            ;C=0 so first ROL leaves A=0
0334 78B2 2A           @3       ROL   A                        ;
0335 78B3 C9 0A                 CMP   #10                      ;A >= 10?
0336 78B5 90 02                 BCC   @4                       ;Branch if <
0337 78B7 E9 0A                 SBC   #10                      ;C=1 frm CMP and is left set
0338 78B9 2E 21 02     @4       ROL   IN+$21                   ;
0339 78BC 2E 20 02              ROL   IN+$20                   ;
0340 78BF CA                    DEX                            ;
0341 78C0 D0 F0                 BNE   @3                       ;
0342 78C2 09 B0                 ORA   #$B0                     ;Make an ascii char
0343 78C4 99 00 02              STA   IN,Y                     ;
0344 78C7 88                    DEY                            ;
0345 78C8 F0 08                 BEQ   @5                       ;Stop on 0,7,14
0346 78CA C0 07                 CPY   #7                       ;
0347 78CC F0 04                 BEQ   @5                       ;
0348 78CE C0 0E                 CPY   #14                      ;
0349 78D0 D0 DB                 BNE   @2                       ;
0350 78D2              @5       EQU   *                        ;
0351 78D2 60                    RTS                            ;Return to caller
0352 78D3
0353 78D3              * End of MHEXTODEC routine
0354 78D3
